/**
 * Common code for Akamai Captcha
 * Currently supports:
 * 1. Google ReCaptcha
 * 2. FunCaptcha
 */

var AKCPT = (function(){
    var akcpt = {},
        ifcpt = document.getElementById('sec-cpt-if');

    (function(open) {
        XMLHttpRequest.prototype.open = function() {
            this.addEventListener("readystatechange", function() {
                if(this.readyState == 4 && this.status == 428) {
                    akCptCallBack(this);
                }
            }, false);
            open.apply(this, arguments);
            url = arguments[1];
            hostname = window.location.hostname;
            if (starts(url,'/') || url.indexOf(hostname) !== -1) {
                this.setRequestHeader('SEC_REQ_TYPE','ajax');
            }
        }
    })(XMLHttpRequest.prototype.open);

    function starts(strInput, matchString) {
        return strInput.lastIndexOf(matchString, 0) === 0;
    }

    function akCptCallBack(xhttp) {
        try {
            var data = JSON.parse(xhttp.responseText);
        } catch(e) {
            var data = {}
        }
        if(data.hasOwnProperty('challenge')){
            if(data["challenge"] == "true") {
                if (data["provider"] == "whiteshadow"){
                    var chlge_prefix = "_ws";
                } else {
                    var chlge_prefix = "_sec";
                }
                document.getElementById('sec-container').innerHTML = '<a href="javascript:void(0)" class="closebtn" onclick="document.getElementById(\'sec-overlay\').style.display = \'none\';">&times;</a>\
                <div id="sec-text-container">\
                <iframe id="sec-text-if" class="custmsg" src="'+data["branding_url_content"]+'?lang='+data["lang"]+'" frameborder="0" scrolling="no"></iframe>\
                </div>\
                <div id="sec-if-container">\
                <iframe id="sec-cpt-if" class="'+data["provider"]+'" data-key="'+data["provider_secret_public"]+'" src="/'+chlge_prefix+"/"+data["env"]+"/"+data["provider"]+'.htm?lang='+data["lang"]+'" frameborder="0" scrolling="no"></iframe>\
                </div>';
                document.getElementById('sec-overlay').style.display = 'block';
            }
        }
    }

    function bindEvent(element, eventName, eventHandler) {
        if (element.addEventListener){
            element.addEventListener(eventName, eventHandler, false);
        } else if (element.attachEvent) {
            element.attachEvent('on' + eventName, eventHandler);
        }
    }
    
    bindEvent(window, 'message', function (e) {
        try {
            msg = JSON.parse(e.data);
        } catch(e) {
            msg = {}
        }
        if(msg.hasOwnProperty('captcha_response')){
            akcpt.verifyCaptcha(msg['captcha_response']);
        }
    });

    akcpt.verifyCaptcha = function(captcha_response) {
        var url = '/_sec/ak_challenge/verify';
        var xhttp;
        xhttp=new XMLHttpRequest();
        xhttp.onreadystatechange = function() {
            if(this.readyState == 4 && this.status == 200) {
                try {
                    var data = JSON.parse(xhttp.responseText);
                } catch(e) {
                    var data = {}
                }
                if(data.hasOwnProperty('success')){
                    if(data["success"] == "true") {
                        document.getElementById('sec-overlay').style.display = 'none';
                    } else {
                        msg = {"captcha_reset":"true"};
                        ifcpt.contentWindow.postMessage(JSON.stringify(msg), '*');
                    }
                }
            }
        };
        xhttp.open("GET", url+'?cpt-token='+captcha_response, true);
        xhttp.send();
    }
    return akcpt;
}());